{
  open Parser        (* The type token is defined in parser.mli *)
  open Lexing

(* on va même essayer de faire un vrai parser... 
   [certains bouts pompés directement à la Source, avec un grand S] 
*)



(* quelques mots reservés [il n'y en a pas beaucoup en uCaml] *)
let create_hashtable size init =
  let tbl = Hashtbl.create size in
  List.iter (fun (key, data) -> Hashtbl.add tbl key data) init;
  tbl;;

let keyword_table =
  create_hashtable 11 [
    "let", LET;
    "rec", REC;
    "in", IN;
    "fun", FUN;
    "function", FUN;
    "if", IF;
    "then", ELSE;
    "else", ELSE;
    "call/cc", CALL_CC;
    "false", FALSE;
    "true", TRUE];;

(* To buffer string literals *)

let initial_string_buffer = String.create 256
let string_buff = ref initial_string_buffer
let string_index = ref 0
(*let string_start_loc = ref Location.none;; *)

let reset_string_buffer () =
  string_buff := initial_string_buffer;
  string_index := 0

let store_string_char c =
  if !string_index >= String.length (!string_buff) then begin
    let new_buff = String.create (String.length (!string_buff) * 2) in
      String.blit (!string_buff) 0 new_buff 0 (String.length (!string_buff));
      string_buff := new_buff
  end;
  String.unsafe_set (!string_buff) (!string_index) c;
  incr string_index

let get_stored_string () =
  let s = String.sub (!string_buff) 0 (!string_index) in
  string_buff := initial_string_buffer;
  s

let char_for_backslash = function
  | 'n' -> '\010'
  | 'r' -> '\013'
  | 'b' -> '\008'
  | 't' -> '\009'
  | c   -> c;;
}

let newline = ('\010' | '\013' | "\013\010")
let blank = [' ' '\009' '\012']
let lowercase = ['a'-'z' '\223'-'\246' '\248'-'\255' '_']
let uppercase = ['A'-'Z' '\192'-'\214' '\216'-'\222']
let identchar = 
  ['A'-'Z' 'a'-'z' '_' '/' '\192'-'\214' '\216'-'\246' '\248'-'\255' '\'' '0'-'9']
let decimal_literal =
  ['0'-'9'] +
let hex_literal =
  '0' ['x' 'X'] ['0'-'9' 'A'-'F' 'a'-'f']['0'-'9' 'A'-'F' 'a'-'f' '_']*
let oct_literal =
  '0' ['o' 'O'] ['0'-'7'] ['0'-'7' '_']*
let bin_literal =
  '0' ['b' 'B'] ['0'-'1'] ['0'-'1' '_']*
let int_literal =
  decimal_literal | hex_literal | oct_literal | bin_literal
let float_literal =
  ['0'-'9'] + 
  ('.' ['0'-'9' '_']* )?
  (['e' 'E'] ['+' '-']? ['0'-'9'] +)?



rule token = parse
  | blank +                
      {token lexbuf}
  | newline                
      {token lexbuf (* on pourrait compter les lignes... *)}


(* quelques pictogrames... *)
  | '.'                    {POINT}
  | "->"                   {TO}
  | '+'                    {PLUS} 
  | '['                    {LCR}
  | ']'                    {RCR}
  | '{'                    {LP}
  |'}'                     {RP}
  | ";;"                   {SEMISEMI}
  | '('                    {LPAR}
  | ')'                    {RPAR}
  | ';'                    {SEMI}
  | '<'                    {LESS}
  | '-'                    {MINUS}
  | ','                    {COMA}
  | '*'                    {TIMES}
  | '/'                    {DIV}
  | '^'                    {CHAPEAU}
  | '%'                    {REM}
  | "::"                   {COLONCOLON}
  | '='                    {EQUAL}
  | eof                    {EOF}


(* gestion des constantes (int, float, string....) *)
  | int_literal            
      { INT (int_of_string (Lexing.lexeme lexbuf)) } 
  | float_literal          
      { FLOAT (float_of_string (Lexing.lexeme lexbuf)) }
  | "\""
      { reset_string_buffer();
        let string_start = lexbuf.lex_start_p in
(*        string_start_loc := Location.curr lexbuf; *)
        string lexbuf;
        lexbuf.lex_start_p <- string_start;
        STRING (get_stored_string()) }


(* gestion simultanée des mot-clefs et des noms de variable *)
  | lowercase identchar *
      { let s = Lexing.lexeme lexbuf in
          try
	    Hashtbl.find keyword_table s
          with Not_found -> VAR s 
      }


and string = parse
    '"'
      { () }
  | '\\' newline ([' ' '\t'] * as space)
      { string lexbuf }
(*  ceci concerne toute la gestion des caractères genre : \231

    | '\\' ['\\' '\'' '"' 'n' 't' 'b' 'r']
      { store_string_char(char_for_backslash(Lexing.lexeme_char lexbuf 1));
        string lexbuf }
  | '\\' ['0'-'9'] ['0'-'9'] ['0'-'9']
      { store_string_char(char_for_decimal_code lexbuf 1);
         string lexbuf }
  | '\\' 'x' ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F']
      { store_string_char(char_for_hexadecimal_code lexbuf 2);
         string lexbuf }
  | '\\' _
      { if in_comment ()
        then string lexbuf
        else begin
(*  Should be an error, but we are very lax.
          raise (Error (Illegal_escape (Lexing.lexeme lexbuf),
                        Location.curr lexbuf))
*)
          let loc = Location.curr lexbuf in
          let warn = Warnings.Other "Illegal backslash escape in string" in
          Location.prerr_warning loc warn;
          store_string_char (Lexing.lexeme_char lexbuf 0);
          store_string_char (Lexing.lexeme_char lexbuf 1);
          string lexbuf
        end
      }*)

  | newline
      { (*update_loc lexbuf None 1 false 0;*)
        let s = Lexing.lexeme lexbuf in
        for i = 0 to String.length s - 1 do
          store_string_char s.[i];
        done;
        string lexbuf
      }
  | eof
      { failwith "parsing : Unterminated string" }
  | _
      { store_string_char(Lexing.lexeme_char lexbuf 0);
        string lexbuf }
