type t_variable = string

(***********************************************************************
 *                            cont. passing style                      *
 ***********************************************************************)

(* domaine des valeurs des expressions *)
type t_domaine = 
  | Entier of int
  | String of string
  | Float of float
  | Booleen of bool
  | Liste of t_domaine list
  | Continuation of t_cont
  | Fonction of (t_cont * t_domaine -> t_domaine)
and t_cont = t_domaine -> t_domaine

(* en cas de plantage... *)
exception Bottom;;

(* le type des expressions *)
type t_expr = Variable of t_variable
		      | Lambda of t_variable * t_expr
		      | App of t_expr * t_expr
		      | Const of t_domaine
		      | Plus of t_expr * t_expr
		      | Moins of t_expr * t_expr
		      | Oppose of t_expr
		      | Fois of t_expr * t_expr
		      | Divise of t_expr * t_expr
		      | Reste of t_expr * t_expr
		      | Egal of t_expr * t_expr
		      | Inferieur of t_expr * t_expr
		      | Si of t_expr * t_expr * t_expr
		      | Let of t_variable * t_expr * t_expr
		      | LetRec of t_variable * t_expr * t_expr
		      | Empty
		      | Cons of t_expr * t_expr
		      | Callcc of t_variable * t_expr
		      | Throw of t_expr * t_expr
		      | Call_cc
		      | Concat of t_expr * t_expr
