exception Erreur;;

(***** L'algorithme d'approximation glouton *****)

let get_nearest_neighbour m l = let mini = ref 1000000. and indice =ref 0
						    and bidon = ref 0
						    in
for i = 0 to (Array.length l) -1 do
  if l.(i)=0 &&  m.(i) < !mini then begin
    bidon := 1;
    indice := i;
    mini := m.(i);
  end;
done;
if !bidon = 0 then raise Erreur else !indice;;

let rec greedy_approx1 g depart actuel deja_vu =
  deja_vu.(actuel) <- 1;
  try
    let k = get_nearest_neighbour g.(actuel) deja_vu in
    let tmp = greedy_approx1 g depart k deja_vu in
    (fst tmp +. g.(actuel).(k) , k::(snd tmp))
  with
      Erreur -> g.(actuel).(depart),[depart];;

let greedy_approx g =
  let tmp = greedy_approx1 g 0 0 (Array.make (Array.length g) 0) in
  (fst tmp, 0::(snd tmp));;

(****************** new version *****************)


let rec distance_cycle g a = function
  [] -> 0.0   (* le cycle est vide : le premier va faire l'affaire *)
| x::suite when x = a -> failwith "merde !"
| x::[] -> g.(x).(a)
| x::suite -> min g.(x).(a) (distance_cycle g a suite);;


let rec meilleur_grapillage g cycle = function
  [] -> failwith "impossible"    (* Plus de candidats *)
| x::[] -> (x, []), (distance_cycle g x cycle) 
| x::suite -> ( 
                match ((meilleur_grapillage g cycle suite), (distance_cycle g x cycle)) with
		  ((i, reste),d1), d2 when d1 < d2 -> (i, (x::reste)), d1
		| ( _        ,d1), d2              -> (x, suite), d2
	      );;
		  

let rec insertion a cycle position = 
  match position, cycle with
    0, apres -> a::apres
  | n, []    -> failwith "insertion au-del de la fin"
  | n, x::suite -> x :: (insertion a suite (n-1));;

let rec meilleure_insertion g a = function
  [] -> a :: []
| cycle ->  
  let c = Array.of_list cycle and n = List.length cycle and best = ref 10000000.0 and best_pos = ref 0 in
    for i = 0 to n do
      let gain = g.(c.(i mod n)).(a) +. g.(c.((i+1) mod n)).(a) -. g.(c.(i mod n)).(c.((i+1) mod n)) in
        if gain < !best then
          (
            best := gain;
            best_pos := i ;
          )
    done;
    insertion a cycle !best_pos;;
    
(*let rec meilleure_insertion g a cycle = function
  0 -> let tmp = insertion a cycle 0
         in tmp, (Trajet.longueur g tmp)
| n -> (
         match (insertion a cycle n), (meilleure_insertion g a cycle (n-1)) with
           c1, (c2, d) when (Trajet.longueur g c1) < d -> c1, Trajet.longueur g c1
         | c1, (c2, d) -> c2,d
       );;  *)


let rec better_greedy_ g cycle_actuel = function
  [] -> cycle_actuel
| candidats -> match meilleur_grapillage g cycle_actuel candidats with
                   (sommet, restant), _ -> 
                      let new_cycle = meilleure_insertion g sommet cycle_actuel in
                        better_greedy_ g new_cycle restant;;

let better_greedy g =
  let t = better_greedy_ g [] (Permutation.intervalle ((Array.length g) - 1)) in
    let t2 = t @ [List.hd t] in
      (Trajet.longueur g t2), t2;;

(******************** random greedization ***********************)                   


let rec random_greedy_ g cycle_actuel = function
  [] -> cycle_actuel
| x::suite -> random_greedy_ g (meilleure_insertion g x cycle_actuel) suite;;

let random_greedy g =
  let t = random_greedy_ g [] (List.tl (Permutation.aleatoire g)) in
    let t2 = t @ [List.hd t] in
      (Trajet.longueur g t2), t2;;		
		  


